unit main;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.Buttons;

type
  TCreateChatForm = function(AId, APwd, APName: PChar; AIsAutoLogin: Boolean): HWND; cdecl;
  TDestoryChatForm = procedure; stdcall;

  TForm1 = class(TForm)
    BitBtn1: TBitBtn;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BitBtn1Click(Sender: TObject);

  private
    FChatFormHwnd: HWND;
    FChatFormLib: THandle;

  public

  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  ShowWindow(FChatFormHwnd, SW_SHOW);
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var
  DestoryChatForm: TDestoryChatForm;
begin
  if FChatFormLib <> 0 then
  begin
    @DestoryChatForm := GetProcAddress(FChatFormLib, 'DestoryChatForm');
    if @DestoryChatForm <> nil then
      DestoryChatForm;
    FreeLibrary(FChatFormLib);
  end;
end;

procedure TForm1.FormShow(Sender: TObject);
var
  CreateChatForm: TCreateChatForm;
begin
  FChatFormLib := Loadlibrary('UDSClientLib.dll');
  if FChatFormLib <> 0 then
  begin
    @CreateChatForm := GetProcAddress(FChatFormLib, 'CreateChatForm');
    if @CreateChatForm <> nil then
      FChatFormHwnd := CreateChatForm(PChar('aa'), PChar('aa'), PChar('TestUser'), True);
  end;
end;

end.
